/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package products;

import java.text.NumberFormat;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class SundryItem implements Item, TaxableItem {
    
    //Fields
    final String name;
    String description;
    protected double price;
    
    @Override
    public double calculateTax(){
        return price*0.075;
    }
    
    public SundryItem(String name) {
        this.name=name;
    }
    
    @Override
    public void enterDescription(String comment) {
        this.description=comment;
    }

    @Override
    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }
    
    //This method will be used whenever anyone want to print out the details of a product.
    @Override
    public void printProduct() {
        //Print out Name, Description and Price
        System.out.println("Name: " + getName());
        System.out.println("Description: " + getDescription());
        System.out.println("Price: " + getFormattedPrice());
    }
    
    @Override
    public String getFormattedPrice() {
        //Define our format as the default currency.
        NumberFormat defaultFormat = NumberFormat.getCurrencyInstance();
        
        //return the price in the default format.
        return defaultFormat.format(price);
    }

    @Override
    public double getPrice() {
        return price;
    }
        
    @Override
    public void setPrice(double price) {
            if (price >= 0) {
                this.price = price;
            } else {//Price is negative
                System.out.println("You can not enter a negative price.");
            }
    }
}
